/*
** Criar uma procedure que monta o arquivo em anexo (Respeitando o layout do arquivo).
*/

CREATE TABLE #TEMP
(
    CONTEUDO varchar(MAX)
);

BULK INSERT #TEMP FROM 'C:\dev\CTodos-PS\scripts-db\ARQUIVO_IMPORTACAO_USUARIO.TXT'
WITH
(
	FIRSTROW = 2
)


DECLARE @LINHA VARCHAR(MAX);
DECLARE @NOME VARCHAR(70);
DECLARE @LOGIN VARCHAR(30);
DECLARE @EMAIL VARCHAR(60);

DECLARE @INDICE_EMAIL INT;
DECLARE @INDICE_NOME INT;

DECLARE CURSOR_IMPORT CURSOR FOR
    SELECT * FROM #TEMP


OPEN CURSOR_IMPORT

FETCH NEXT FROM CURSOR_IMPORT INTO @LINHA;

WHILE @@FETCH_STATUS = 0
BEGIN

	--SELECT @LINHA
	SET @LOGIN = LEFT(@LINHA, CHARINDEX(' ', @LINHA));
	SET @EMAIL = REVERSE(LEFT(REVERSE(RTRIM(@LINHA)), CHARINDEX(' ', REVERSE(RTRIM(@LINHA)))));
    
	SET @INDICE_EMAIL = CHARINDEX(@EMAIL, @LINHA);
	SET @INDICE_NOME = CHARINDEX(' ', @LINHA);

	SET @NOME = RTRIM(SUBSTRING(@LINHA, @INDICE_NOME, @INDICE_EMAIL - @INDICE_NOME));

	-- removendo os espaos em branco
	SET @LOGIN = LTRIM(RTRIM(@LOGIN));
	SET @NOME = LTRIM(RTRIM(@NOME));
	SET @EMAIL = LTRIM(RTRIM(@EMAIL));

	IF ((SELECT COUNT(*) FROM USUARIO WHERE LOGIN = @LOGIN) = 0)
	BEGIN
		INSERT INTO USUARIO (LOGIN, NOME, EMAIL, ATIVO, DT_INCLUSAO) VALUES (@LOGIN, @NOME, @EMAIL, 1, GETDATE());
	END
	ELSE
		UPDATE USUARIO SET LOGIN = @LOGIN, NOME = @NOME, EMAIL = @EMAIL WHERE LOGIN = @LOGIN;

    FETCH NEXT FROM CURSOR_IMPORT INTO @LINHA
END


CLOSE CURSOR_IMPORT
DEALLOCATE CURSOR_IMPORT 

DROP TABLE #TEMP
